{
    This file is part of RA1792Control

    RACAL RA1792 Control program

    Copyright (C) 2014-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.
}

unit urxaddr;

{$mode objfpc}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  Spin, StdCtrls;

type

  { TFADDR }

  TFADDR = class(TForm)
    BOK: TButton;
    SPRXADD: TSpinEdit;
    procedure BOKClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FADDR: TFADDR;

implementation

uses uRA1792;

{ TFADDR }

procedure TFADDR.BOKClick(Sender: TObject);
begin
  FADDR.Hide;
  RXAddress := SPRXADD.Value;
  RA1792.MRXADD.Caption := Format(MRXADDCAPT,[RXAddress]);
  RA1792.SaveConfig;
end;

initialization
  {$I urxaddr.lrs}

end.

