{
    This file is part of RA3701Control

    RACAL RA3701 Control program

    Copyright (C) 2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.

                                   * * *
    Shows program manual
}

unit UMAN;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GetText;

type

  { TFMAN }

  TFMAN = class(TForm)
          Button1: TButton;
          MANMEMO: TMemo;
          procedure Button1Click(Sender: TObject);
          procedure FormCreate(Sender: TObject);
          procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FMAN: TFMAN;
  OW, OH, OFH: integer;

implementation

uses ura3701;

{$R *.lfm}

{ TFMAN }

procedure TFMAN.Button1Click(Sender: TObject);
begin
        FMan.Hide;
end;

procedure TFMAN.FormCreate(Sender: TObject);

var Lang: string = '';
    FallbackLang: string = '';

begin
  // See if there is an internationalization for the manual

  // Read system language
  GetLanguageIDs(Lang, FallbackLang);
  Lang := copy(Lang,1,2);

  // Check if system language is overridden by a command line switch
  if (ParamCount() = 1) and (Pos('--lang', ParamStr(1)) <> 0) then
        Lang := Copy(ParamStr(1),8,2);
  if (ParamCount() = 2) and (Pos('-l',ParamStr(1)) <> 0) then
        Lang := ParamStr(2);

  if FileExists(DocDir+'Manual-'+Lang+'.txt') then
     // Read in the translated manual
     MANMEMO.Lines.LoadFromFile(DocDir+'Manual-'+Lang+'.txt')
  else
     // Read in the english text version of the manpage
     MANMEMO.Lines.LoadFromFile(DocDir+'Manual-en.txt');

  // Save starting width, height & font height
  OW := FMAN.Width;
  OH := FMAN.Height;
  OFH := MANMEMO.Font.Height;
end;

procedure TFMAN.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
    NewFontHeight := (OFH * FontMagn) div 100;
    MANMEMO.Font.Height := NewFontHeight;
    FMAN.Width := (OW * FontMagn) div 100;
    FMAN.Height := (OH * FontMagn) div 100;
    FMAN.Left := (Screen.Width-FMAN.Width) div 2;
    FMAN.Top := (Screen.Height-FMAN.Height) div 2;
end;

end.

