{
    This file is part of SkantiControl

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units. The CU
    firmware version can be either 80R or 92.

    Copyright (C) 2012-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.


    Hamlib net rigctl compatible TCP server address and port selection
}

unit UTCP;

{$mode ObjFPC}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  DefaultTranslator;

type

  { TFTCP }

  TFTCP = class(TForm)
    BOK: TButton;
    EDADDPORT: TEdit;
    procedure BOKClick(Sender: TObject);
  private

  public

  end;

var
  FTCP: TFTCP;

// Messages are declared here for i18n
resourcestring
  INVALIDSYNTAX='Invalid syntax, use address:port';

implementation

uses Skanti;

{ TFTCP }

// Read address:port for the hamlib net rigctl compatible server

// 'OK' button handling
procedure TFTCP.BOKClick(Sender: TObject);

var s: string;
    p: integer;

begin
  s := EDADDPORT.Text;
  p := Pos(':',s);

  if p > 0 then begin
    TRP.TRPSERVER.Host := Copy(s,1,p-1);
    TRP.TRPServer.Port := StrToInt(Copy(s,p+1));
    TRP.TRPServer.Disconnect;
    TRP.TRPServer.Listen(TRP.TRPServer.Port,TRP.TRPServer.Host);
    TRP.SaveConfig;
    FTCP.Hide;
  end else begin
    EDADDPORT.Font.Color := clRed;
    ShowMessage(INVALIDSYNTAX);
    EDADDPORT.Clear;
    EDADDPORT.Font.Color := clBlack;
  end;
end;

initialization
  {$I UTCP.lrs}

end.

