{
    This file is part of EKD500Control

    RFT EKD500 Control program

    Copyright (C) 2012-2022 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.
}

//
// TCP server address:port configuration
// default is 127.0.0.1:4538
//

unit UTCP;

{$mode ObjFPC}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  DefaultTranslator;

type

  { TFTCP }

  TFTCP = class(TForm)
    BOK: TButton;
    EDADDPORT: TEdit;
    procedure BOKClick(Sender: TObject);
  private

  public

  end;

var
  FTCP: TFTCP;

// Messages are declared here for i18n
resourcestring
  INVALIDSYNTAX='Invalid syntax, use address:port';

implementation

uses EKD500;

{ TFTCP }

// OK button
procedure TFTCP.BOKClick(Sender: TObject);

var s: string;
    p: integer;

begin
  s := EDADDPORT.Text;
  p := Pos(':',s);

  if p > 0 then begin
    EKD.EKD500SERVER.Host := Copy(s,1,p-1);
    EKD.EKD500SERVER.Port := StrToInt(Copy(s,p+1));
    EKD.EKD500SERVER.Disconnect;
    EKD.EKD500SERVER.Listen(EKD.EKD500SERVER.Port, EKD.EKD500SERVER.Host);
    EKD.SaveConfig;
    FTCP.Hide;
  end else begin
    EDADDPORT.Font.Color := clRed;
    ShowMessage(INVALIDSYNTAX);
    EDADDPORT.Clear;
    EDADDPORT.Font.Color := clBlack;
  end;
end;

initialization
  {$I UTCP.lrs}

end.

