{
    This file is part of RA3701Control

    RACAL RA3701 Control program

    Copyright (C) 2023 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.

    RA3701 error list
}

unit uerrorlist;

{$mode ObjFPC}{$H+}

interface

uses
  Classes, SysUtils;

procedure GetTestDescription(sTestNum: string; out sBlock,sDescr: string);

implementation

type TTestItem = record
  TestNo: string[4];
  TestBlock: string[20];
  TestDescr: string[20];
end;

const
 TestList: array[1..109] of TTestItem = (
  (TestNo:'001';TestBlock:'Processor';TestDescr:'Checksum PD1'),
  (TestNo:'002';TestBlock:'Processor';TestDescr:'Checksum PD2'),
  (TestNo:'003';TestBlock:'Processor';TestDescr:'RAM test ML17'),
  (TestNo:'004';TestBlock:'Processor';TestDescr:'RAM test ML15'),
  (TestNo:'005';TestBlock:'Processor';TestDescr:'EEROM test'),
  (TestNo:'006';TestBlock:'Processor';TestDescr:'+5V rail'),
  (TestNo:'007';TestBlock:'Processor';TestDescr:'+15V rail'),
  (TestNo:'008';TestBlock:'Processor';TestDescr:'-15V rail'),
  (TestNo:'009';TestBlock:'Processor';TestDescr:'+24V rail'),
  (TestNo:'010';TestBlock:'Processor';TestDescr:'-5V rail'),
  (TestNo:'011';TestBlock:'Processor';TestDescr:'DAC test'),
  (TestNo:'012';TestBlock:'Processor';TestDescr:'Processor I/O'),
  (TestNo:'013';TestBlock:'Processor';TestDescr:'Parallel I/O 1'),
  (TestNo:'014';TestBlock:'Processor';TestDescr:'Parallel I/O 2'),

  (TestNo:'051';TestBlock:'RX Config.';TestDescr:'Master port INT'),
  (TestNo:'052';TestBlock:'RX Config.';TestDescr:'Master port EXT'),
  (TestNo:'053';TestBlock:'RX Config.';TestDescr:'Trib. port INT'),
  (TestNo:'054';TestBlock:'RX Config.';TestDescr:'Trib. port EXT'),
  (TestNo:'055';TestBlock:'RX Config.';TestDescr:'IEEE 488 Interface'),

  (TestNo:'101';TestBlock:'RX bus';TestDescr:'RX data bus'),
  (TestNo:'102';TestBlock:'RX bus';TestDescr:'RX address data'),
  (TestNo:'103';TestBlock:'RX bus';TestDescr:'RX bus control'),
  (TestNo:'104';TestBlock:'RX bus';TestDescr:'RX BITE bus'),

  (TestNo:'151';TestBlock:'Front panel';TestDescr:'BITE hardware'),
  (TestNo:'152';TestBlock:'Front panel';TestDescr:'+5V rail'),
  (TestNo:'153';TestBlock:'Front panel';TestDescr:'+15V audio rail'),
  (TestNo:'154';TestBlock:'Front panel';TestDescr:'-15V rail'),
  (TestNo:'155';TestBlock:'Front panel';TestDescr:'+15V rail'),
  (TestNo:'156';TestBlock:'Front panel';TestDescr:'Displays Test'),
  (TestNo:'157';TestBlock:'Front panel';TestDescr:'Keyboard Test'),

  (TestNo:'201';TestBlock:'Reference/BFO';TestDescr:'BITE hardware'),
  (TestNo:'202';TestBlock:'Reference/BFO';TestDescr:'+5V rail'),
  (TestNo:'203';TestBlock:'Reference/BFO';TestDescr:'+15V rail'),
  (TestNo:'204';TestBlock:'Reference/BFO';TestDescr:'BFO Ref level'),
  (TestNo:'205';TestBlock:'Reference/BFO';TestDescr:'BFO Ref lock'),
  (TestNo:'206';TestBlock:'Reference/BFO';TestDescr:'Ref Osc. varac V'),
  (TestNo:'207';TestBlock:'Reference/BFO';TestDescr:'40 MHz o/p level'),
  (TestNo:'208';TestBlock:'Reference/BFO';TestDescr:'BFO lock'),
  (TestNo:'209';TestBlock:'Reference/BFO';TestDescr:'BFO Osc. varac V'),
  (TestNo:'210';TestBlock:'Reference/BFO';TestDescr:'BFO sweep'),
  (TestNo:'211';TestBlock:'Reference/BFO';TestDescr:'BFO o/p level'),

  (TestNo:'251';TestBlock:'1st LO Synth.';TestDescr:'BITE hardware'),
  (TestNo:'252';TestBlock:'1st LO Synth.';TestDescr:'+5.2V rail'),
  (TestNo:'253';TestBlock:'1st LO Synth.';TestDescr:'+15V rail'),
  (TestNo:'254';TestBlock:'1st LO Synth.';TestDescr:'+24V rail'),
  (TestNo:'255';TestBlock:'1st LO Synth.';TestDescr:'+9V rail'),
  (TestNo:'256';TestBlock:'1st LO Synth.';TestDescr:'-15V rail'),
  (TestNo:'257';TestBlock:'1st LO Synth.';TestDescr:'Synth. varactor'),
  (TestNo:'258';TestBlock:'1st LO Synth.';TestDescr:'Synth. range'),
  (TestNo:'259';TestBlock:'1st LO Synth.';TestDescr:'Synth. sweep'),
  (TestNo:'260';TestBlock:'1st LO Synth.';TestDescr:'Synth. o/p level'),


  (TestNo:'301';TestBlock:'IF/AF';TestDescr:'BITE hardware'),
  (TestNo:'302';TestBlock:'IF/AF';TestDescr:'+5V rail'),
  (TestNo:'303';TestBlock:'IF/AF';TestDescr:'+15V rail'),
  (TestNo:'304';TestBlock:'IF/AF';TestDescr:'+10V rail'),
  (TestNo:'305';TestBlock:'IF/AF';TestDescr:'-15V rail'),
  (TestNo:'306';TestBlock:'IF/AF';TestDescr:'IF amplifier'),
  (TestNo:'307';TestBlock:'IF/AF';TestDescr:'IF filter'),
  (TestNo:'308';TestBlock:'IF/AF';TestDescr:'2nd IF AGC'),
  (TestNo:'309';TestBlock:'IF/AF';TestDescr:'AGC detector'),
  (TestNo:'310';TestBlock:'IF/AF';TestDescr:'AGC distribution'),
  (TestNo:'311';TestBlock:'IF/AF';TestDescr:'AGC decay'),
  (TestNo:'312';TestBlock:'IF/AF';TestDescr:'AGC hang'),
  (TestNo:'313';TestBlock:'IF/AF';TestDescr:'AGC dump'),
  (TestNo:'314';TestBlock:'IF/AF';TestDescr:'Product detector'),
  (TestNo:'315';TestBlock:'IF/AF';TestDescr:'AM detector'),
  (TestNo:'316';TestBlock:'IF/AF';TestDescr:'FM detector'),

  (TestNo:'351';TestBlock:'Front End';TestDescr:'BITE hardware'),
  (TestNo:'352';TestBlock:'Front End';TestDescr:'+5V rail'),
  (TestNo:'353';TestBlock:'Front End';TestDescr:'+15V rail'),
  (TestNo:'354';TestBlock:'Front End';TestDescr:'+24V rail'),
  (TestNo:'355';TestBlock:'Front End';TestDescr:'+12V rail'),
  (TestNo:'356';TestBlock:'Front End';TestDescr:'-L5V rail'),
  (TestNo:'357';TestBlock:'Front End';TestDescr:'1st mix drive lvl'),
  (TestNo:'358';TestBlock:'Front End';TestDescr:'1st mix drive swp'),
  (TestNo:'359';TestBlock:'Front End';TestDescr:'2nd mix drive lv1'),
  (TestNo:'360';TestBlock:'Front End';TestDescr:'RX gain'),
  (TestNo:'361';TestBlock:'Front End';TestDescr:'1st IF gain'),

  (TestNo:'401';TestBlock:'100 kHz Module';TestDescr:'BITE hardware'),
  (TestNo:'402';TestBlock:'100 kHz Module';TestDescr:'+5 Vrail'),
  (TestNo:'403';TestBlock:'100 kHz Module';TestDescr:'+15V rail'),
  (TestNo:'404';TestBlock:'100 kHz Module';TestDescr:'1.4MHzA'),
  (TestNo:'405';TestBlock:'100 kHz Module';TestDescr:'1.4MHzB'),
  (TestNo:'406';TestBlock:'100 kHz Module';TestDescr:'100 KHz A'),
  (TestNo:'407';TestBlock:'100 kHz Module';TestDescr:'100 kHzB'),
  (TestNo:'408';TestBlock:'100 kHz Module';TestDescr:'5 MHz level'),

  (TestNo:'451';TestBlock:'FSK Module';TestDescr:'BITE hardware'),
  (TestNo:'452';TestBlock:'FSK Module';TestDescr:'+5V rail'),
  (TestNo:'453';TestBlock:'FSK Module';TestDescr:'+15V rail'),
  (TestNo:'454';TestBlock:'FSK Module';TestDescr:'-15V rail'),
  (TestNo:'455';TestBlock:'FSK Module';TestDescr:'FSK disc. sweep'),
  (TestNo:'456';TestBlock:'FSK Module';TestDescr:'FSK meter sweep'),
  (TestNo:'457';TestBlock:'FSK Module';TestDescr:'FSK slicer sweep'),


  (TestNo:'501';TestBlock:'ISB Module';TestDescr:'BITE hardware'),
  (TestNo:'502';TestBlock:'ISB Module';TestDescr:'+5V rail'),
  (TestNo:'503';TestBlock:'ISB Module';TestDescr:'+15V rail'),
  (TestNo:'504';TestBlock:'ISB Module';TestDescr:'+10V rail'),
  (TestNo:'505';TestBlock:'ISB Module';TestDescr:'-15V rail'),
  (TestNo:'506';TestBlock:'ISB Module';TestDescr:'IF amplifier'),
  (TestNo:'507';TestBlock:'ISB Module';TestDescr:'AGC detector'),
  (TestNo:'508';TestBlock:'ISB Module';TestDescr:'AGC distribution'),
  (TestNo:'509';TestBlock:'ISB Module';TestDescr:'AGC decay'),
  (TestNo:'510';TestBlock:'ISB Module';TestDescr:'AGC hang'),
  (TestNo:'511';TestBlock:'ISB Module';TestDescr:'AGC dump'),
  (TestNo:'512';TestBlock:'ISB Module';TestDescr:'Product detector'),


  (TestNo:'551';TestBlock:'IF Filter';TestDescr:'BITE hardware'),
  (TestNo:'552';TestBlock:'IF Filter';TestDescr:'+5V rail'),
  (TestNo:'553';TestBlock:'IF Filter';TestDescr:'+15V rail'),
  (TestNo:'554';TestBlock:'IF Filter';TestDescr:'-15V rail')
);

resourcestring
  UNKNOWN = 'unknown';

procedure GetTestDescription(sTestNum: string; out sBlock, sDescr:string);

var i: integer;
    found: boolean;

begin
  found := FALSE;
  for i := 1 to 109 do
    if sTestNum=TestList[i].TestNo then begin
      found := TRUE;
      break;
    end;
  if found then begin
    sBlock := Testlist[i].TestBlock;
    sDescr := Testlist[i].TestDescr;
  end else begin
    sBlock := UNKNOWN;
    sDescr := UNKNOWN;
  end;
end;

end.






