{
    This file is part of SkantiControl

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units. The CU
    firmware version can be either 80R or 92.

    Copyright (C) 2012-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.

    Serial port select dialog
}

unit user;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TFSerPort }

  TFSerPort = class(TForm)
    BOK: TButton;
    ESer: TEdit;
    procedure BOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FSerPort: TFSerPort;
  OW,OH,OFH: integer;

implementation

{$R *.lfm}

{ TFSerPort }

uses skanti;

// 'OK' button handling
procedure TFSerPort.BOKClick(Sender: TObject);
begin

{$IFDEF LINUX}
  if pos('/dev', Eser.Text) = 0 then
    SerPortName := '/dev/' + Eser.Text
  else
    SerPortName := Eser.Text;
{$ENDIF}

{$IFDEF WINDOWS}
  // The \\.\ syntax is optional for ports 1..9 but is needed
  // for ports > 9, so insert it anyway if not present
  if pos('\\.\',Eser.Text) = 0 then
     SerPortName := '\\.\' + Eser.Text
  else
      SerPortName := Eser.Text;
{$ENDIF}

  TRP.SaveConfig;
  FSerPort.Hide;
end;

// At startup, read starting dimensions
procedure TFSerPort.FormCreate(Sender: TObject);
begin
  // Save starting width, height & font height
  OW := FSERPORT.Width;
  OH := FSERPORT.Height;
  OFH := ESER.Font.Height;
end;

// When showing the form, scale it
procedure TFSerPort.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
  NewFontHeight := (OFH * FontMagn) div 100;
  ESER.Font.Height := NewFontHeight;
  FSERPORT.Width := (OW * FontMagn) div 100;
  FSERPORT.Height := (OH * FontMagn) div 100;
  FSERPORT.Left := (Screen.Width-FSERPORT.Width) div 2;
  FSERPORT.Top := (Screen.Height-FSERPORT.Height) div 2;
end;

end.

