{
    This file is part of RA3701Control

    RACAL RA3701 Control program

    Copyright (C) 2025,2026 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.

                                    * * *

    Hamlib rigctld-maybe-compatible RA3701 control net server.
    The strictly-networking part is in skanti.pas using lNET.

    Rigctld commands are only partially coded. The implementation uses
    only the basic remote command capabilities of the RA1792.
    ==========================================================================
                                   WANTED
    ==========================================================================
             Someone with better knowledge of how rigctld works
                to help complete/correct the implementation.
    ==========================================================================
}

unit UState;

{$mode ObjFPC}

interface

uses
  Classes, SysUtils;

// This is what is returned by rigctld in response to the dump_state command for
// RA6790/GM rig model, with some modifications by trial and error, since the
// meaning of most of these bytes is unknown to me.
var RA3701_State: array of string = (
  '1',
  '11003',
  '0',
  '00015.000000 29999999.000000 0x2f -1 -1 0x1 0x0',
  '0 0 0 0 0 0 0',
  '0 0 0 0 0 0 0',
  '0x2f 1',
  '0 0',
  '0x20 12000',        // FM Normal
  '0x20 12000',        // FM Wide
  '0x20 6000',         // FM Narrow
  '0x10 1000',         // RTTY Normal
  '0x10 2700',         // RTTY Wide
  '0x10 300',          // RTTY Narrow
  '0x08 2700',         // LSB Normal
  '0x08 3200',         // LSB Wide
  '0x08 2700',         // LSB Narrow
  '0x04 2700',         // USB Normal
  '0x04 3200',         // USB Wide
  '0x04 2700',         // USB Narrow
  '0x02 1000',         // CW Normal
  '0x02 2700',         // CW Wide
  '0x02 300',          // CW Narrow
  '0x01 6000',         // AM Normal
  '0x01 12000',        // AM Wide
  '0x01 3200',         // AM Narrow
  '0 0',
  '0',
  '0',
  '8000',
  '0',
  '',
  '',
  '0x0',
  '0x0',
  '0x40020000',   // get_level: STRENGTH and AGC
  '0x20000',      // set_level: AGC
  '0x0',
  '0x0',
  'done'
);

implementation

end.

